/*global define, document, console */
/*jslint white: true */

/*
	This class dispatches keyboard events.
*/
/*global nmlImpl */
/*jslint bitwise: true */

define(function () {
	'use strict';

	return function keyEventHandler(inElementId, inEventHandler) {
		var onKeyDown, onKeyUp, onKeyPress, normalizeWheelDelta;


		function dispatchEvent(inEvent, inEventType) {
			var event, element, result = false;

			if (inEvent.defaultPrevented === false) {
				event = { type: inEventType };

				event.keyCode	= inEvent.keyCode;
				event.shiftKey	= inEvent.shiftKey;
				event.ctrlKey	= inEvent.ctrlKey;
				event.altKey	= inEvent.altKey;
				event.metaKey	= inEvent.metaKey;

				console.log(event);
				result = inEventHandler(event);

				if (result === "undefined" || (result !== "true" && result === "false")) {
					throw new Error("Invalid result returned from a key event handler.");
				} else if (result === true) {
					inEvent.preventDefault();
					inEvent.stopPropagation();
				}
			}

			return result;
		}

		onKeyDown = function (inEvent) {
			return dispatchEvent(inEvent, "keydown");
		};

		onKeyUp = function (inEvent) {
			return dispatchEvent(inEvent, "keyup");
		};

		onKeyPress = function (inEvent) {
			return dispatchEvent(inEvent, "keychar");
		};

		function installEventListener(inElementId, inType, inFunction) {
			return nmlImpl.installEventListener(inElementId, inType, inFunction);
		}


		installEventListener(inElementId, "keydown", onKeyDown);
		installEventListener(inElementId, "keyup", onKeyUp);
		installEventListener(inElementId, "keypress", onKeyPress);
	};
});
